/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.planning.mokos.MokosScoreDefinition;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.util.Tuple;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LexicographicSelector
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(LexicographicSelector.class);
    private static final boolean DEBUG = false;
    private MokosScoreDefinition[] scoreDefs;

    public void setScoreKeys(String ... scoreKeys) {
        Preconditions.checkNotNull(scoreKeys);
        this.scoreDefs = new MokosScoreDefinition[scoreKeys.length];
        for (int i = 0; i < scoreKeys.length; ++i) {
            Preconditions.checkNotNull(scoreKeys[i]);
            this.scoreDefs[i] = new MokosScoreDefinition();
            this.scoreDefs[i].setScoreProperty(scoreKeys[i]);
        }
    }

    public void setScoreDefs(MokosScoreDefinition ... scoreDefs) {
        this.scoreDefs = scoreDefs;
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        Preconditions.checkState(this.scoreDefs != null && this.scoreDefs.length != 0, "No score definitions.");
        if (ops.isEmpty()) {
            return Tuple.create(this.getDefaultSuccessor(), ops);
        }
        Operation selectedOp = null;
        Operation.OperationPlanning selectedPlanning = null;
        int dominantKey = -1;
        int planningCnt = 0;
        Object[] hiScores = new Object[this.scoreDefs.length];
        int hiEquivCnt = 0;
        for (Operation op : ops) {
            block1: for (Operation.OperationPlanning planning : op.getPlannings()) {
                int i;
                this.checkScoresValid(op, planning);
                ++planningCnt;
                if (selectedPlanning == null) {
                    selectedOp = op;
                    selectedPlanning = planning;
                    for (i = 0; i < this.scoreDefs.length; ++i) {
                        hiScores[i] = planning.getProperty(this.scoreDefs[i].getScoreProperty());
                    }
                    continue;
                }
                for (i = 0; i < this.scoreDefs.length; ++i) {
                    Comparable score = (Comparable)planning.getProperty(this.scoreDefs[i].getScoreProperty());
                    int scoreComparison = score.compareTo(hiScores[i]);
                    if (scoreComparison != 0) {
                        if (this.scoreDefs[i].getOrdering() == MokosScoreDefinition.Ordering.LARGE_FIRST && scoreComparison > 0 || this.scoreDefs[i].getOrdering() == MokosScoreDefinition.Ordering.SMALL_FIRST && scoreComparison < 0) {
                            if (op != selectedOp) {
                                selectedOp.clearPlannings();
                            }
                            selectedOp = op;
                            selectedPlanning = planning;
                            for (int j = i; j < this.scoreDefs.length; ++j) {
                                hiScores[j] = planning.getProperty(this.scoreDefs[j].getScoreProperty());
                            }
                            dominantKey = i;
                            hiEquivCnt = 0;
                            continue block1;
                        }
                        dominantKey = Math.max(dominantKey, i);
                        continue block1;
                    }
                    if (i != this.scoreDefs.length - 1) continue;
                    ++hiEquivCnt;
                }
            }
            if (op == selectedOp) continue;
            op.clearPlannings();
        }
        Preconditions.checkState(selectedOp != null, "None of the input operations was planned.");
        selectedOp.retainPlanning(selectedPlanning);
        if (hiEquivCnt > 0) {
            log.warn("Found {} operation plannings that scored equivalently as the selected one. Results may vary across MoKoS runs.", (Object)hiEquivCnt);
        }
        return Tuple.create(this.getDefaultSuccessor(), Collections.singleton(selectedOp));
    }

    private void checkScoresValid(Operation op, Operation.OperationPlanning planning) {
        for (MokosScoreDefinition scoreDef : this.scoreDefs) {
            Object score = planning.getProperty(scoreDef.getScoreProperty());
            Preconditions.checkArgument(score != null, "Missing property '%s'. Operation '%s'; planning '%s'.", (Object)scoreDef.getScoreProperty(), (Object)op, (Object)planning);
            Preconditions.checkArgument(score instanceof Comparable, "All scores must implement 'Comparable' interface. '%s' of %s is %s.", (Object)scoreDef.getScoreProperty(), (Object)planning, score.getClass());
        }
    }
}

